--eval
local t = LoadFallbackB();

t[#t+1] = StandardDecorationFromFileOptional( "StageDisplay", "StageDisplay" );
t[#t+1] = StandardDecorationFromFileOptional( "WinDisplay", "WinDisplay" );

-- life graph
local function GraphDisplay( pn )
	local t = Def.ActorFrame {
		Def.GraphDisplay {
			InitCommand=cmd(Load,"GraphDisplay"..ToEnumShortString(pn););
			BeginCommand=function(self)
				local ss = SCREENMAN:GetTopScreen():GetStageStats();
				self:Set( ss, ss:GetPlayerStageStats(pn) );
				self:player( pn );
				local pm = GAMESTATE:GetPlayMode()
				if pm == "PlayMode_Rave" and pn == PLAYER_1 then
					self:rotationz(180);
					self:rotationy(180);
				end
			end
		};
	};
	return t;
end

if ShowStandardDecoration("GraphDisplay") then
	for pn in ivalues(PlayerNumber) do
		t[#t+1] = StandardDecorationFromTable( "GraphDisplay" .. ToEnumShortString(pn), GraphDisplay(pn) );
	end
end

-- combo graph
local function ComboGraph( pn )
	local t = Def.ActorFrame {
		Def.ComboGraph {
			InitCommand=cmd(Load,"ComboGraph"..ToEnumShortString(pn););
			BeginCommand=function(self)
				local ss = SCREENMAN:GetTopScreen():GetStageStats();
				self:Set( ss, ss:GetPlayerStageStats(pn) );
				self:player( pn );
			end
		};
	};
	return t;
end

if ShowStandardDecoration("ComboGraph") then
	for pn in ivalues(PlayerNumber) do
		t[#t+1] = StandardDecorationFromTable( "ComboGraph" .. ToEnumShortString(pn), ComboGraph(pn) );
	end
end

local function PercentScoreText( pn )
	local t = LoadFont("ScreenEvaluation percent text")..{
		InitCommand=cmd(player,pn);
		BeginCommand=cmd(playcommand,"Set");
		SetCommand=function(self)
			-- todo: color by difficulty
			local SongOrCourse, StepsOrTrail;
			if GAMESTATE:IsCourseMode() then
				SongOrCourse = GAMESTATE:GetCurrentCourse()
				StepsOrTrail = GAMESTATE:GetCurrentTrail(pn)
			else
				SongOrCourse = GAMESTATE:GetCurrentSong()
				StepsOrTrail = GAMESTATE:GetCurrentSteps(pn)
			end;
			if SongOrCourse and StepsOrTrail then
				local st = StepsOrTrail:GetStepsType();
				local diff = StepsOrTrail:GetDifficulty();
				local courseType = GAMESTATE:IsCourseMode() and SongOrCourse:GetCourseType() or nil;
				local cd = GetCustomDifficulty(st, diff, courseType);
			end

			local pss = STATSMAN:GetPlayedStageStats(1):GetPlayerStageStats(pn);
			if pss then
				local pct = pss:GetPercentDancePoints();
				local DPforOni = PREFSMAN:GetPreference('DancePointsForOni');
				local pm = GAMESTATE:GetPlayMode()
				if not DPforOni and pm == "PlayMode_Oni" then
					if pct == 1 then
						self:settext("100%");
						self:addx(14);
					elseif pct == 0 then
						self:settext("0%");
						self:addx(14);
					else
						self:settext(FormatPercentScore(pct));
					end;
					self:diffusealpha(0);
					self:horizalign(center);
					self:vertalign(bottom);
					self:maxwidth(180);
					self:addx(-9);
					self:addy(3);
					self:zoom(0.75);
					self:zoomy(3);
					self:sleep(1);
					self:linear(0.2);
					self:zoomy(0.75);
					self:diffusealpha(1);
				elseif pm == "PlayMode_Endless" then
					self:diffusealpha(0);
				elseif pm == "PlayMode_Rave" then
					self:diffusealpha(0);
				else
					if pct == 1 then
						self:settext("100%");
						self:addx(14);
					elseif pct == 0 then
						self:settext("0%");
						self:addx(14);
					else
						self:settext(FormatPercentScore(pct));
					end;
					self:maxwidth(180);
					self:diffusealpha(0);
					self:addy(14);
					self:zoom(0.4);
					self:sleep(1);
					self:linear(0.2);
					self:diffusealpha(1);
				end;
			end;
		end;
	};
	return t;
end

if ShowStandardDecoration("PercentScore") then
	for pn in ivalues(PlayerNumber) do
		t[#t+1] = StandardDecorationFromTable( "PercentScore" .. ToEnumShortString(pn), PercentScoreText(pn) );
	end
end

for pn in ivalues(PlayerNumber) do
	local MetricsName = "MachineRecord" .. PlayerNumberToString(pn);
	t[#t+1] = LoadActor( THEME:GetPathG(Var "LoadingScreen", "MachineRecord"), pn ) .. {
		InitCommand=function(self) 
			self:player(pn); 
			self:name(MetricsName); 
			ActorUtil.LoadAllCommandsAndSetXY(self,Var "LoadingScreen"); 
		end;
	};
end

for pn in ivalues(PlayerNumber) do
	local MetricsName = "PersonalRecord" .. PlayerNumberToString(pn);
	t[#t+1] = LoadActor( THEME:GetPathG(Var "LoadingScreen", "PersonalRecord"), pn ) .. {
		InitCommand=function(self) 
			self:player(pn); 
			self:name(MetricsName); 
			ActorUtil.LoadAllCommandsAndSetXY(self,Var "LoadingScreen"); 
		end;
	};
end

t[#t+1] = StandardDecorationFromFileOptional("SongInformation","SongInformation") .. {
	BeginCommand=function(self)
		local SongOrCourse;
		if GAMESTATE:GetCurrentSong() then
			SongOrCourse = GAMESTATE:GetCurrentSong();
		elseif GAMESTATE:GetCurrentCourse() then
			SongOrCourse = GAMESTATE:GetCurrentCourse();
		else
			return
		end
		
		if SongOrCourse:HasBanner() then
			self:visible(false);
		else
			self:visible(true);
		end
	end;
	SetCommand=function(self)
		local c = self:GetChildren();
		local SongOrCourse;
		if GAMESTATE:GetCurrentSong() then
			SongOrCourse = GAMESTATE:GetCurrentSong();
			c.Font = "_shared2";
			c.TextTitle:settext( SongOrCourse:GetDisplayMainTitle() or nil );
			c.TextSubtitle:settext( SongOrCourse:GetDisplaySubTitle() or nil );
			c.TextArtist:settext( SongOrCourse:GetDisplayArtist() or nil );
			-- no subtitle
			if SongOrCourse:GetDisplaySubTitle() == "" then
				c.TextTitle:visible(true);
				c.TextTitle:y(-9);
				c.TextTitle:diffuse( SONGMAN:GetSongColor(SongOrCourse) );
				c.TextTitle:horizalign(right);
				c.TextSubtitle:visible(false);
				c.TextSubtitle:y(0);
				c.TextSubtitle:diffuse( SONGMAN:GetSongColor(SongOrCourse) );
				c.TextSubtitle:horizalign(right);
				c.TextArtist:visible(true);
				c.TextArtist:y(9);
				c.TextArtist:zoom(0.575);
				c.TextArtist:diffuse( SONGMAN:GetSongColor(SongOrCourse) );
				c.TextArtist:horizalign(right);
			-- yes subtitle
			else
				c.TextTitle:visible(true);
				c.TextTitle:y(-23/2);
				c.TextTitle:zoomy(0.9);
				c.TextTitle:diffuse( SONGMAN:GetSongColor(SongOrCourse) );
				c.TextTitle:horizalign(right);
				c.TextSubtitle:visible(true);
				c.TextSubtitle:y(2);
				c.TextSubtitle:zoomx(0.575);
				c.TextSubtitle:zoomy(0.565);
				c.TextSubtitle:diffuse( SONGMAN:GetSongColor(SongOrCourse) );
				c.TextSubtitle:horizalign(right);
				c.TextArtist:visible(true);
				c.TextArtist:y(12);
				c.TextArtist:zoomx(0.6);
				c.TextArtist:zoomy(0.565);
				c.TextArtist:diffuse( SONGMAN:GetSongColor(SongOrCourse) );
				c.TextArtist:horizalign(right);
			end
-- 			self:playcommand("Tick");
		elseif GAMESTATE:GetCurrentCourse() then
			SongOrCourse = GAMESTATE:GetCurrentCourse();
			
			c.TextTitle:settext( SongOrCourse:GetDisplayMainTitle() or nil );
			c.TextSubtitle:settext( SongOrCourse:GetDisplaySubTitle() or nil );
			c.TextArtist:settext( SongOrCourse:GetDisplayArtist() or nil );
			
-- 			self:playcommand("Tick");
		else
			SongOrCourse = nil;
			
			c.TextTitle:settext("");
			c.TextSubtitle:settext("");
			c.TextArtist:settext("");
			
			self:playcommand("Hide")
		end
	end;
-- 	OnCommand=cmd(playcommand,"Set");
	CurrentSongChangedMessageCommand=cmd(playcommand,"Set");
	CurrentCourseChangedMessageCommand=cmd(playcommand,"Set");
	DisplayLanguageChangedMessageCommand=cmd(playcommand,"Set");
};
t[#t+1] = StandardDecorationFromFileOptional("LifeDifficulty","LifeDifficulty");
t[#t+1] = StandardDecorationFromFileOptional("TimingDifficulty","TimingDifficulty");

for pn in ivalues(GAMESTATE:GetHumanPlayers()) do
	local MetricsName = "DifficultyIcon"..PlayerNumberToString(pn);
	t[#t+1] = StandardDecorationFromFile(MetricsName,MetricsName);
end;

t[#t+1] = StandardDecorationFromFileOptional( "TryExtraStage", "TryExtraStage" );

return t;